package it.unicam.pizzeria4.servizio;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

import it.unicam.pizzeria4.services.DBManager;
import it.unicam.pizzeria4.util.Course;
import it.unicam.pizzeria4.util.DatiPiatto;
import it.unicam.pizzeria4.util.DettagliMenu;
import it.unicam.pizzeria4.util.MenuObserver;

public class Menu {

	private static Menu instance;

	private int dataInizio;
	private int dataFine;
	private ArrayList<Piatto> listaPiatti;
	private ArrayList<Bibita> listaBibite;
	private ArrayList<MenuObserver> subscribers;

	private Menu() {
		super();
		listaPiatti = new ArrayList<Piatto>();
		listaBibite = new ArrayList<Bibita>();
		subscribers = new ArrayList<MenuObserver>();
	}

	public static Menu getInstance() {
		if (instance == null) {
			instance = new Menu();
		}
		return instance;
	}

	public void setMenu(ArrayList<DatiPiatto> descrizionePiatti) {
		Iterator<DatiPiatto> dpi = descrizionePiatti.iterator();
		DatiPiatto dPiatto;
		Piatto piatto;
		while (dpi.hasNext()) {
			dPiatto = dpi.next();
			piatto = new Piatto(dPiatto.getID(), dPiatto.getNome(), dPiatto.getIngredienti(),
					Course.values()[dPiatto.getTipo()], dPiatto.getIntolleranze());
			piatto.setPrezzo(dPiatto.getPrezzo());
			listaPiatti.add(piatto);

		}
	}

	public void setDataInizio(int dataInizio) {
		this.dataInizio = dataInizio;
	}

	public void setDataFine(int dataFine) {
		this.dataFine = dataFine;
	}

	public void addPiatto(Piatto piatto) {
		listaPiatti.add(piatto);
	}

	public void addBibita(Bibita bibita) {
		listaBibite.add(bibita);
	}

	public ArrayList<DettagliMenu> getPiattiBibiteDisponibili() {
		ArrayList<DettagliMenu> dettagliMenu = new ArrayList<DettagliMenu>();
		Iterator<Piatto> lpi = listaPiatti.iterator();
		Piatto piatto;
		String ingredienti;
		String intolleranze;
		while (lpi.hasNext()) {
			ingredienti = "";
			piatto = lpi.next();
			if (piatto.getIngredienti().length > 0) {
				for (int k = 0; k < piatto.getIngredienti().length; k++) {
					ingredienti += piatto.getIngredienti()[k];
					ingredienti += (k==(piatto.getIngredienti().length-1) ? "" : ", ");
				}
			} else {
				ingredienti = "n.a.";
			}
			intolleranze = (piatto.getIntolleranze() == "" ? "n.a." : piatto.getIntolleranze());
			dettagliMenu.add(new DettagliMenu(piatto.getID(), piatto.getNome(), piatto.getTipo(), piatto.getPrezzo(),
					"\n  Ingredienti: " + ingredienti + "\n  Intolleranze: " + intolleranze));
		}
		Iterator<Bibita> lbi = listaBibite.iterator();
		Bibita bibita;
		while (lbi.hasNext()) {
			bibita = lbi.next();
			dettagliMenu.add(new DettagliMenu(bibita.getID(), bibita.getNome(),
					(bibita.isAlcolica() ? Course.bibitaAlcolica : Course.bibitaAnalcolica), bibita.getPrezzo(),
					"Intolleranze:" + bibita.getIntolleranze()));
		}
		return dettagliMenu;
	}

	/**
	 * 
	 * @param idPiatto
	 */
	public Piatto getPiatto(String idPiatto) {
		Iterator<Piatto> lpi = listaPiatti.iterator();
		Piatto piatto = null;
		boolean trovato = false;
		while (!trovato && lpi.hasNext()) {
			piatto = lpi.next();
			if (piatto.getID().equals(idPiatto)) {
				trovato = true;
			}
		}
		if (trovato)
			return piatto;
		System.out.println("[ERROR]: Attenzione l'identificativo " + idPiatto + " non corrisponde a nessun piatto");
		return null;
	}

	/**
	 * 
	 * @param idBibita
	 */
	public Bibita getBibita(String idBibita) {
		Iterator<Bibita> lbi = listaBibite.iterator();
		Bibita bibita = null;
		boolean trovato = false;
		while (!trovato && lbi.hasNext()) {
			bibita = lbi.next();
			if (bibita.getID().equals(idBibita)) {
				trovato = true;
			}
		}
		if (trovato)
			return bibita;
		System.out.println("[ERROR]: Attenzione l'identificativo " + idBibita + " non corrisponde a nessuna bibita");
		return null;
	}

	public void scegliMenu(String menu) {
		listaPiatti.clear();
		try {
			setMenu(DBManager.getInstance().setMenu(menu));
		} catch (SQLException e) {
			e.printStackTrace();
		}
		Iterator<MenuObserver> moi = subscribers.iterator();
		while (moi.hasNext()) {
			moi.next().update();
		}
		
	}
	
	public void subscribe(MenuObserver mo) {
		subscribers.add(mo);
	}

	public void unsubscribe(MenuObserver mo) {
		subscribers.remove(mo);
	}

}
